// The struct layout here was tested on Ubuntu Linux 18.04.
// Other Unix flavors may require a different layout.
// The *.h files for the system's C compiler are a good starting point.
Console.WriteLine (GetSystemTime());

static DateTime GetSystemTime()
{
  DateTime startOfUnixTime =
    new DateTime (1970, 1, 1, 0, 0, 0, 0, System.DateTimeKind.Utc);

  Timespec tp = new Timespec();
  int success = clock_gettime (0, ref tp);
  if (success != 0) throw new Exception ("Error checking the time.");
  return startOfUnixTime.AddSeconds (tp.tv_sec).ToLocalTime();
}

[DllImport ("libc")]
static extern int clock_gettime (int clk_id, ref Timespec tp);

[StructLayout (LayoutKind.Sequential)]
struct Timespec
{
  public long tv_sec;   /* seconds */
  public long tv_nsec;  /* nanoseconds */
}